varying vec2 f_texcoord;

uniform sampler2D texture;
uniform float factor;

void main(void)
{
	vec3 colorResult = texture2D(texture, f_texcoord).rgb;

	const vec3 lumFactor = vec3(0.2, 0.7, 0.1);
	const float brightness = 0.5;
	float luminance = dot(lumFactor, colorResult) * brightness;
	vec3 colorBW = vec3(luminance, luminance, luminance);
	colorResult = mix(colorResult, colorBW, factor);

	gl_FragColor = vec4(colorResult, 1.0);
}
